/*:
 * @target MZ
 * @plugindesc Öffnet eine URL im extra Fenster (neutral, sauber, ohne Browserrahmen) via NW.js ✨
 * @author YuiNya
 *
 * @command openURL
 * @text Öffne URL (im Fenster)
 * @desc Öffnet eine Webseite im schlanken Fenster
 *
 * @arg url
 * @text URL
 * @desc Die Adresse, die geöffnet werden soll
 * @type string
 * @default https://www.hinazawa.com
 *
 */

(() => {
    PluginManager.registerCommand("OpenURL", "openURL", args => {
        const url = args.url;
        if (Utils.isNwjs()) {
            const gui = require("nw.gui");
            gui.Window.open(url, {
                title: "Hinazawa Terminal",
                width: 1024,
                height: 600,
                frame: true,
                resizable: true
            });
        } else {
            window.open(url, "_blank");
        }
    });
})();
